<?php
/*

Copyright (c)2003 DuckCorp(tm) and RtpNet(tm)



This file is part of DFTK.

DFTK is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DFTK is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DFTK  if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/**
 * @package		dftk
 * @author		Duck <duck@DuckCorp.org>
 * @author		Rtp <rtp@rtp-net.org>
 * @copyright	Copyright (c)2003 DuckCorp(tm) and RtpNet(tm)
 * @license		http://www.gnu.org/licenses/gpl.html					GNU General Public License
 * @version		0.4.0
 */


/**
 * DFTK Language Manager Class
 *
 * @package			dftk
 * @subpackage		dftk-language
 * @author			Duck <duck@DuckCorp.org>
 *
 * @access			public
 */
class DftkDaLanguageManager
{
	/**
	 * List of registered directories for translations
	 *
	 * @access		private
	 * @var			array
	 */
	var	$_dirlist;

	/**
	 * List of translations for the selected language
	 *
	 * @access		private
	 * @var			array
	 */
	var	$_trans;

	/**
	 * Language to use currently
	 *
	 * @access		private
	 * @var			string
	 */
	var	$_lang;

	/**
	 * Encoding to use currently
	 *
	 * @access		private
	 * @var			string
	 */
	var	$_encoding;

	/**
	 * Constructor
	 *
	 * @access		public
	 */
	function DftkDaLanguageManager()
	{
		$this->_dirlist = array();
		$this->_trans = array();
		$this->_lang = "en";
		$this->_encoding = "UTF-8";
	}

	/**
	 * Select Language to use
	 *
	 * @access		public
	 * @param		string				$lang					Language name
	 */
	function set_lang($lang)
	{
		$this->_lang = strtolower($lang);
		$this->reload();
	}

	/**
	 * Select Encoding to use
	 *
	 * @access		public
	 * @param		string				$encoding					Encofing name
	 */
	function set_encoding($encoding)
	{
		$this->_encoding = strtoupper($encoding);
	}

	/**
	 * Reload translation files
	 *
	 * @access		public
	 */
	function reload()
	{
		$this->_trans = array();
		foreach ($this->_dirlist as $dir)
		{
			$this->_load($dir);
		}
	}

	/**
	 * Register a directory where to find translation files
	 *
	 * @access		public
	 * @param		string				$dir					Directory path
	 */
	function add_trans($dir)
	{
		if (file_exists($dir))
		{
			$this->_dirlist[] = $dir;
			$this->_load($dir);
		}
	}

	/**
	 * Load tranlation files in the specified directory
	 *
	 * @access		private
	 * @param		string				$dir					Directory path
	 */
	function _load($dir)
	{
		if (file_exists($dir."/".$this->_lang))
		{
			$handle = opendir($dir."/".$this->_lang);
			while ($file = readdir($handle))
			{
				if ($file=='.' || $file=='..')
					continue;
				if (is_dir($file))
					continue;
				$z = parse_ini_file($dir."/".$this->_lang."/".$file);
				$this->_trans = array_merge($this->_trans, $z);
			}
			closedir($handle);
		}
	}

	/**
	 * Ask for a translated message
	 *
	 * @access		public
	 * @param		string				$key					Id of the message
	 * @param		array				$params					Parameters for the message
	 * @return		string				$msg
	 */
	function get_msg($key, $params=array())
	{
		$msg = $this->_trans[$key];

		if (!$msg)
			return "[No Translation Defined for message '".$key."' in language '".$this->_lang."']";

		if (count($params) != 0)
			for ($i=0; $i<count($params); $i++)
			{
				$msg = preg_replace("/<#(\d)>/", "\$params[\\1]", $msg);
				eval("\$msg = \"$msg\";");
			}
			
		if ($this->_encoding == "UTF-8")
			return $msg;

		$enc_msg = iconv("UTF-8", $this->_encoding."//TRANSLIT", $msg);

		if ($enc_msg === false)
			return "[Bad encoding selected, falling back to 'UTF-8'] ".$msg;
		else
			return $enc_msg;
	}

	/**
	 * Get the list of existing message Ids
	 *
	 * @access		public
	 * @return		array				$tab					Array of existing message Ids
	 */
	function get_msg_list()
	{
		$tab = array();
		foreach ($this->_trans as $key => $val)
			$tab[] = $key;

		return $tab;
	}
}

?>
